#include "board.h"
#include <klocale.h>
#include <qpixmap.h>
#include <qiconset.h>
#include <kmessagebox.h>
#include <qfile.h>
#include <qtextstream.h>
#include <kdebug.h>
#include <kstddirs.h>

Board::Board(QWidget *parent, const char *name)
: KListView(parent, name)
{
	m_changed = 0;

	setCaption("Vinyl albums"); // FIXME: dummy

	setMultiSelection(true);
	setAllColumnsShowFocus(true);
}

Board::~Board()
{
}

void Board::init(int type)
{
	KStandardDirs d;

	// FIXME: read that from the config files

	while(columns()) removeColumn(0);

	if(type == 0)
	{
		addColumn(QIconSet(QPixmap(d.findResource("data", "novinyl/title.png"))), i18n("Title"));
		addColumn(QIconSet(QPixmap(d.findResource("data", "novinyl/artist.png"))), i18n("Author(s)"));
		addColumn(QIconSet(QPixmap(d.findResource("data", "novinyl/medium.png"))), i18n("Medium"));
		addColumn(QIconSet(QPixmap(d.findResource("data", "novinyl/year.png"))), i18n("Year"));
	}
	else if(type == 1)
	{
		addColumn(QIconSet(QPixmap(d.findResource("data", "novinyl/appname.png"))), i18n("Application name"));
		addColumn(QIconSet(QPixmap(d.findResource("data", "novinyl/artist.png"))), i18n("Author(s)"));
		addColumn(QIconSet(QPixmap(d.findResource("data", "novinyl/description.png"))), i18n("Description"));
		addColumn(QIconSet(QPixmap(d.findResource("data", "novinyl/year.png"))), i18n("Year"));
	}
}

void Board::slotNewTrack(QString medium, QString year, QString artist, QString title)
{
	(void)new KListViewItem(this, title, artist, medium, year);
	m_changed = 1;
}

void Board::deleteTracks()
{
	for(QListViewItem *tmp = firstChild(); tmp; tmp = tmp->nextSibling())
	{
		if(tmp->isSelected())
		{
			delete tmp;
			m_changed = 1;
			// The high art of efficient algorithms :)
			tmp = firstChild();
			if(!tmp) return;
		}
	}
}

void Board::clear()
{
	int ret;

	if(m_changed)
		ret = KMessageBox::questionYesNo(this, "Create a new database without saving the current one?", "New file");
	if((!m_changed) || (ret == KMessageBox::Yes))
	{
		KListView::clear();
		m_changed = 0;
	}
}

void Board::save(QString filename)
{
	QFile f(filename);
	if(f.open(IO_ReadWrite))
	{
		QTextStream t(&f);
		for(QListViewItem *tmp = firstChild(); tmp; tmp = tmp->nextSibling())
		{
			t << tmp->text(0);
			t << "\t";
			t << tmp->text(1);
			t << "\t";
			t << tmp->text(2);
			t << "\t";
			t << tmp->text(3);
			t << "\n";
		}
		f.close();
		m_changed = 0;
	}
	else KMessageBox::error(this, "Couldn't save file!", "Error");
}

void Board::load(QString filename)
{
	QString s;
	QStringList l;
	QString title, artist, medium, year;

	clear();
	init(0); // !!!

	QFile f(filename);
	if(f.open(IO_ReadOnly))
	{
		QTextStream t(&f);
		while(!t.eof())
		{
			s = t.readLine();
			l = l.split('\t', s);
			QStringList::Iterator it = l.begin();
			title = (*it);
			it++;
			artist = (*it);
			it++;
			medium = (*it);
			it++;
			year = (*it);
			slotNewTrack(medium, year, artist, title);
		}
		m_changed = 0;
	}
	else KMessageBox::error(this, "Couldn't read file!", "Error");
}

