#include "entry.h"
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <klocale.h>
#include <qpixmap.h>
#include <kstddirs.h>

Entry::Entry(QWidget *parent, const char *name)
: QWidget(parent, name)
{
	QVBoxLayout *vbox, *vbox10, *vbox11, *vbox12;
	QHBoxLayout *hbox1, *hbox2;
	QLabel *title, *latitle, *laartist, *lamedium, *layear;
	QPushButton *ok, *cancel;
	QWidget *ptitle, *partist, *pmedium, *pyear;
	QGridLayout *grid;
	KStandardDirs d;

	title = new QLabel(i18n("Please enter the track details."), this);

	ok = new QPushButton(i18n("Add"), this);
	cancel = new QPushButton(i18n("Cancel"), this);

	latitle = new QLabel(i18n("Title:"), this);
	laartist = new QLabel(i18n("Author:"), this);
	lamedium = new QLabel(i18n("Medium:"), this);
	layear = new QLabel(i18n("Year:"), this);

	ptitle = new QWidget(this);
	partist = new QWidget(this);
	pmedium = new QWidget(this);
	pyear = new QWidget(this);
	ptitle->setBackgroundPixmap(QPixmap(d.findResource("data", "novinyl/title.png")));
	partist->setBackgroundPixmap(QPixmap(d.findResource("data", "novinyl/artist.png")));
	pmedium->setBackgroundPixmap(QPixmap(d.findResource("data", "novinyl/medium.png")));
	pyear->setBackgroundPixmap(QPixmap(d.findResource("data", "novinyl/year.png")));
	ptitle->setFixedSize(16, 16);
	partist->setFixedSize(16, 16);
	pmedium->setFixedSize(16, 16);
	pyear->setFixedSize(16, 16);

	edtitle = new QLineEdit(this);
	edartist = new QLineEdit(this);
	edmedium = new QLineEdit(this);
	edyear = new QLineEdit(this);

	vbox = new QVBoxLayout(this, 5);
	vbox->add(title);

	grid = new QGridLayout(vbox, 5);
	grid->addWidget(pmedium, 0, 0);
	grid->addWidget(pyear, 1, 0);
	grid->addWidget(partist, 2, 0);
	grid->addWidget(ptitle, 3, 0);
	grid->addWidget(lamedium, 0, 1);
	grid->addWidget(layear, 1, 1);
	grid->addWidget(laartist, 2, 1);
	grid->addWidget(latitle, 3, 1);
	grid->addWidget(edmedium, 0, 2);
	grid->addWidget(edyear, 1, 2);
	grid->addWidget(edartist, 2, 2);
	grid->addWidget(edtitle, 3, 2);

	hbox2 = new QHBoxLayout(vbox, 5);
	hbox2->add(ok);
	hbox2->add(cancel);

	connect(ok, SIGNAL(clicked()), SLOT(slotAccept()));
	connect(cancel, SIGNAL(clicked()), SLOT(close()));

	setCaption("Add a new track");
	resize(300, 200);
	show();
}

Entry::~Entry()
{
}

void Entry::slotAccept()
{
	emit signalNewTrack(edmedium->text(), edyear->text(), edartist->text(), edtitle->text());
	close();
}

