#include "newdb.h"
#include <klocale.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qcombobox.h>

NewDB::NewDB(QWidget *parent, const char *name)
: QWidget(parent, name)
{
	QVBoxLayout *vbox;
	QHBoxLayout *hbox;
	QLabel *label;
	QPushButton *ok, *cancel;

	dbtypes = new QComboBox(this);
	dbtypes->insertItem("Music collections (Novinyl 'classic')");
	dbtypes->insertItem("KDE programs collection");

	label = new QLabel(i18n("Please choose the appropriate database type:"), this);

	ok = new QPushButton(i18n("OK"), this);
	cancel = new QPushButton(i18n("Cancel"), this);

	vbox = new QVBoxLayout(this, 5);
	vbox->add(label);
	vbox->add(dbtypes);
	hbox = new QHBoxLayout(vbox, 5);
	hbox->add(ok);
	hbox->add(cancel);

	connect(ok, SIGNAL(clicked()), SLOT(slotNewDB()));
	connect(cancel, SIGNAL(clicked()), SLOT(close()));

	resize(300, 100);
	setCaption(i18n("New database"));
	show();
}

NewDB::~NewDB()
{
}

void NewDB::slotNewDB()
{
	emit signalNewDB(dbtypes->currentItem());
}

