#include "toplevel.h"
#include "board.h"
#include <kpopupmenu.h>
#include <kmenubar.h>
#include <ksimpleconfig.h>
#include <kstddirs.h>
#include <klocale.h>
#include "entry.h"
#include <kfiledialog.h>
#include "newdb.h"

Toplevel::Toplevel()
: KMainWindow()
{
	KPopupMenu *menu_file, *menu_entry;

	entry = NULL;
	newdb = NULL;

	menu_file = new KPopupMenu(this);
	menu_file->insertItem(i18n("New"), menufilenew);
	menu_file->insertItem(i18n("Open"), menufileopen);
	menu_file->insertSeparator();
	menu_file->insertItem(i18n("Save"), menufilesave);
	menu_file->insertSeparator();
	menu_file->insertItem(i18n("Quit"), menufilequit);

	menu_entry = new KPopupMenu(this);
	menu_entry->insertItem(i18n("New"), menuentrynew);
	menu_entry->insertItem(i18n("Delete selected"), menuentrydelete);

	menuBar()->insertItem(i18n("File"), menu_file);
	menuBar()->insertItem(i18n("Entries"), menu_entry);
	menuBar()->insertItem(i18n("Help"), helpMenu());

	board = new Board(this);
	setCentralWidget(board);
	show();

	connect(menu_file, SIGNAL(activated(int)), SLOT(slotMenu(int)));
	connect(menu_entry, SIGNAL(activated(int)), SLOT(slotMenu(int)));

	resize(600, 620);
}

Toplevel::~Toplevel()
{
}

void Toplevel::slotMenu(int id)
{
	QString x;

	switch(id)
	{
		case menufilenew:
			if(!newdb)
			{
				newdb = new NewDB();
				connect(newdb, SIGNAL(signalNewDB(int)), SLOT(slotNewDB(int)));
			}
			newdb->show();
			break;
		case menufileopen:
			x = KFileDialog::getOpenFileName(QString::null, "*.novinyl");
			if(!x.isEmpty()) board->load(x);
			break;
		case menufilesave:
			x = KFileDialog::getSaveFileName(QString::null, "*.novinyl");
			if(!x.isEmpty()) board->save(x);
			break;
		case menufilequit:
			close();
			break;
		case menuentrynew:
			if(!entry)
			{
				entry = new Entry();
				connect(entry, SIGNAL(signalNewTrack(QString, QString, QString, QString)),
					board, SLOT(slotNewTrack(QString, QString, QString, QString)));
			}
			entry->show();
			break;
		case menuentrydelete:
			board->deleteTracks();
			break;
	}
}

void Toplevel::slotNewDB(int type)
{
	newdb->hide();
	board->init(type);
	board->clear();
}

