#include "board.h"

#include "scheme.h"

#include <kmessagebox.h>
#include <kdebug.h>
#include <kstddirs.h>
#include <ktempfile.h>
#include <klocale.h>
#include <kdebug.h>

#include <qpixmap.h>
#include <qiconset.h>
#include <qfile.h>
#include <qtextstream.h>

#include <stdlib.h>

Board::Board(QWidget *parent, const char *name)
: KListView(parent, name)
{
	m_changed = 0;
	m_replace = NULL;

	setCaption("Vinyl albums"); // FIXME: dummy

	setMultiSelection(true);
	setAllColumnsShowFocus(true);
}

Board::~Board()
{
}

void Board::init(int type)
{
	QList<QString> schemes;
	int i;

	kdDebug() << "Load scheme of type: " << type << endl;
	i = 0;
	schemes = Scheme::instance()->schemes();
	kdDebug() << "Loading done; now processing" << endl;
	for(QString *s = schemes.first(); s; s = schemes.next())
	{
		if(i == type)
		{
			init2(*s);
			break;
		}
		i++;
	}
}

void Board::init2(QString type)
{
	QStringList *l1, *l2;
	QStringList::Iterator it1, it2;
	KStandardDirs d;

	while(columns()) removeColumn(0);

	m_type = type;
	l1 = Scheme::instance()->columns(type);

	kdDebug() << "Load icons" << endl;
	l2 = Scheme::instance()->icons(type);
	if(l1) it1 = l1->begin();
	if(l2) it2 = l2->begin();
	kdDebug() << "Iterate..." << endl;
	while((l1) && (it1 != l1->end()))
	{
		kdDebug() << "Add: " << (*it1) << " - " << (*it2) << endl;
		addColumn(QIconSet(QPixmap(d.findResource("data", "novinyl/" + (*it2) + ".png"))), (*it1));
		it1++;
		if((l2) && (it2 != l2->end())) it2++;
	}
}

void Board::slotNewTrack(QStringList list)
{
	KListViewItem *item;
	int i;

	item = new KListViewItem(this);
	i = 0;
	for(QStringList::Iterator it = list.begin(); it != list.end(); it++)
	{
		item->setText(i, (*it));
		i++;
	}
	if(m_replace)
	{
		delete m_replace;
		m_replace = NULL;
	}
	m_changed = 1;
}

void Board::deleteTracks()
{
	for(QListViewItem *tmp = firstChild(); tmp; tmp = tmp->nextSibling())
	{
		if(tmp->isSelected())
		{
			delete tmp;
			m_changed = 1;
			// The high art of efficient algorithms :)
			tmp = firstChild();
			if(!tmp) return;
		}
	}
}

QStringList Board::list()
{
	QStringList l;
	QListViewItem *item;

	item = currentItem();
	if(item)
	{
		for(int i = 0; i < columns(); i++)
			l.append(item->text(i));
		m_replace = item;
	}
	return l;
}

void Board::clear()
{
	int ret;

	if(m_changed)
		ret = KMessageBox::questionYesNo(this,
			i18n("Create a new database without saving the current one?"), i18n("New file"));
	if((!m_changed) || (ret == KMessageBox::Yes))
	{
		KListView::clear();
		m_changed = 0;
	}
}

void Board::save(QString filename)
{
	if(filename.contains(".ksp"))
	{
		QString tmpprefix = locateLocal("tmp", "");
		KTempFile tmpdoc(tmpprefix + "/novinyl", ".xml");
		KTempFile tmpmain(tmpprefix + "/novinyl", ".xml");
		int j;

		QFile f(tmpdoc.name());
		if(f.open(IO_ReadWrite))
		{
			QTextStream t(&f);
			t << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" << endl;
			t << "<!DOCTYPE document-info>" << endl;
			t << "<document-info>" << endl;
			t << "</document-info>" << endl;
			f.close();
		}
		else KMessageBox::error(this, "Couldn't save file!", "Error");

		QFile f2(tmpmain.name());
		if(f2.open(IO_ReadWrite))
		{
			QTextStream t(&f2);
			t << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" << endl;
			t << "<!DOCTYPE spreadsheet>" << endl;
			t << "<spreadsheet mime=\"application/x-kspread\" editor=\"KSpread\">" << endl;
			t << " <paper format=\"A4\" orientation=\"Portrait\">" << endl;
			t << " </paper>" << endl;
			t << " <map markerColumn=\"1\" activeTable=\"Table1\" markerRow=\"1\">" << endl;
			t << "  <table name=\"Novinyl Exported Table\">" << endl;

			for(int i = 0; i < columns(); i++)
			{
				t << "   <cell row=\"1\" column=\"" << i + 1 << "\">" << endl;
				t << "    <text>" << columnText(i) << "</text>" << endl;
				t << "   </cell>" << endl;
			}

			j = 3;
			for(QListViewItem *tmp = firstChild(); tmp; tmp = tmp->nextSibling())
			{
				for(int i = 0; i < columns(); i++)
				{
					t << "   <cell row=\"" << j + 1 << "\" column=\"" << i + 1 << "\">" << endl;
					t << "    <text>" << tmp->text(i) << "</text>" << endl;
					t << "   </cell>" << endl;
				}
				j++;
			}
			t << "  </table>" << endl;
			t << " </map>" << endl;
			t << "</spreadsheet>" << endl;
			f2.close();
		}
		else
		{
			KMessageBox::error(this, i18n("Couldn't save file!"), i18n("Error"));
			return;
		}

		// FIXME: use KIO::KTar
		QString tarcmd, gzipcmd, movemaincmd, movedoccmd, filename2, movetgzcmd;

		// /path/to/foo.bar.ksp -> foo.bar
		filename2 = filename;
		filename2.remove(filename2.length() - 4, 4);
		int x = filename2.findRev('/');
		if(x > 0) filename2.remove(0, x + 1);

		movemaincmd = "mv " + tmpmain.name() + " " + tmpprefix + "/maindoc.xml";
		movedoccmd = "mv " + tmpdoc.name() + " " + tmpprefix + "/documentinfo.xml";
		tarcmd = "tar --remove-files -C " + tmpprefix + " -cf " + tmpprefix + "/" + filename2 + " ";
		tarcmd += "maindoc.xml documentinfo.xml";
		gzipcmd = "gzip -9 --suffix .ksp " + tmpprefix + "/" + filename2;
		movetgzcmd = "mv " + tmpprefix + "/" + filename2 + ".ksp " + filename;

		kdDebug() << "!!! " << movemaincmd << endl;
		system(movemaincmd.latin1());
		kdDebug() << "!!! " << movedoccmd << endl;
		system(movedoccmd.latin1());
		kdDebug() << "!!! " << tarcmd << endl;
		system(tarcmd.latin1());
		kdDebug() << "!!! " << gzipcmd << endl;
		system(gzipcmd.latin1());
		kdDebug() << "!!! " << movetgzcmd << endl;
		system(movetgzcmd.latin1());
	}
	else
	{
		QFile f(filename);
		if(f.open(IO_ReadWrite))
		{
			QTextStream t(&f);
			/*for(int i = 0; i < columns() - 1; i++)
			{
				t << columnText(i);
				t << "\t";
			}
			t << columnText(columns() - 1);*/
			/*t << endl;
			for(int i = 0; i < columns() - 1; i++)
			{
				t << XXX;
				t << "\t";
			}
			t << XXX;*/
			t << m_type.latin1();
			t << endl << endl;
			for(QListViewItem *tmp = firstChild(); tmp; tmp = tmp->nextSibling())
			{
				for(int i = 0; i < columns() - 1; i++)
				{
					t << tmp->text(i);
					t << "\t";
				}
				t << tmp->text(columns() - 1);
				t << endl;
			}
			f.close();
			m_changed = 0;
		}
		else KMessageBox::error(this, i18n("Couldn't save file!"), i18n("Error"));
	}
}

void Board::load(QString filename)
{
	QString s;
	QStringList l;

	clear();
	//init(0); // !!!

	QFile f(filename);
	if(f.open(IO_ReadOnly))
	{
		QTextStream t(&f);
		if(!t.eof())
		{
			s = t.readLine();
			//l = l.split('\t', s);
			//init2(l); // !!!
			/*for(QStringList::Iterator it = l.begin(); it != l.end(); it++)
			{
				addColumn((*it));
			}*/
			init2(s);
			if(!t.eof()) s = t.readLine();
		}
		while(!t.eof())
		{
			s = t.readLine();
			l = l.split('\t', s);
			slotNewTrack(l);
		}
		m_changed = 0;
	}
	else KMessageBox::error(this, i18n("Couldn't read file!"), i18n("Error"));
}

QString Board::type()
{
	return m_type;
}

