#include "entry.h"

#include "scheme.h"

#include <klocale.h>
#include <kstddirs.h>
#include <kdebug.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qpixmap.h>

Entry::Entry(QWidget *parent, const char *name)
: QWidget(parent, name)
{
	QLabel *title;

	title = new QLabel(i18n("Please enter the track details."), this);

	vbox = new QVBoxLayout(this, 5);
	vbox->add(title);

	grid = new QGridLayout(vbox, 5);
}

void Entry::init(int type)
{
	QList<QString> schemes;
	int i;

	schemes = Scheme::instance()->schemes();
	i = 0;
	for(QString *s = schemes.first(); s; s = schemes.next())
	{
		if(i == type)
		{
			init2(*s);
			break;
		}
		i++;
	}

	setCaption("Add a new track");
	resize(300, 200);
	show();
}

void Entry::init2(QString type)
{
	QStringList *icons, *columns;
	QStringList::ConstIterator it2;
	QString icon, column;
	int i;
	QHBoxLayout *hbox2;
	KStandardDirs d;
	QLabel *wlabel;
	QWidget *wpixmap;
	QLineEdit *wedit;

	i = 0;
	icons = Scheme::instance()->icons(type);
	columns = Scheme::instance()->columns(type);
	if(!columns) return;
	if(icons) it2 = icons->begin();

	for(QStringList::ConstIterator it1 = columns->begin(); it1 != columns->end(); it1++)
	{
		icon = (*it2);
		if(columns) column = (*it1);
		kdDebug() << "Entry: add " << column << endl;;
		wlabel = new QLabel(column, this);
		wedit = new QLineEdit(this);
		editlist.append(wedit);
		wpixmap = new QWidget(this);
		wpixmap->setBackgroundPixmap(QPixmap(d.findResource("data", "novinyl/" + icon + ".png")));
		wpixmap->setFixedSize(16, 16);
		grid->addWidget(wpixmap, i, 0);
		grid->addWidget(wlabel, i, 1);
		grid->addWidget(wedit, i, 2);
		i++;
		if(icons) it2++;
	}

	QPushButton *ok, *cancel;
	ok = new QPushButton(i18n("Add"), this);
	cancel = new QPushButton(i18n("Cancel"), this);

	connect(ok, SIGNAL(clicked()), SLOT(slotAccept()));
	connect(cancel, SIGNAL(clicked()), SLOT(close()));

	hbox2 = new QHBoxLayout(vbox, 5);
	hbox2->add(ok);
	hbox2->add(cancel);
}

Entry::~Entry()
{
}

void Entry::slotAccept()
{
	QStringList list;

	for(QLineEdit *ed = editlist.first(); ed; ed = editlist.next())
		list.append(QString(ed->text()));

	emit signalNewTrack(list);
	close();
}

void Entry::fill(QStringList list)
{
	QStringList::Iterator it;
	QString s;

	it = list.begin();
	for(QLineEdit *ed = editlist.first(); ed; ed = editlist.next())
	{
		if(it != list.end())
		{
			s = (*it);
			ed->setText(s);
			it++;
		}
	}
}

