#include "scheme.h"

#include <kstddirs.h>
#include <kdebug.h>
#include <ksimpleconfig.h>

Scheme *m_instance = NULL;

Scheme* Scheme::instance()
{
	if(!m_instance) m_instance = new Scheme();
	return m_instance;
}

Scheme::Scheme()
{
}

Scheme::~Scheme()
{
}

void Scheme::init()
{
	QString *scheme;
	const QStringList *icon, *column;
	KStandardDirs d;

	QStringList s = d.findAllResources("data", "*.scheme", true);
	for(QStringList::Iterator it = s.begin(); it != s.end(); it++)
	{
		kdDebug() << (*it) << endl;
		KSimpleConfig conf((*it));
		conf.setGroup("Scheme");
		QString desc = conf.readEntry("Scheme");
		QStringList icon2 = conf.readListEntry("Icons");
		QStringList column2 = conf.readListEntry("Fields");
		icon = new QStringList(icon2);
		column = new QStringList(column2);
		scheme = new QString(desc);
		kdDebug() << "Register as: " << *scheme << endl;
		m_schemelist.append(scheme);
		m_iconlist.insert(*scheme, icon);
		m_columnlist.insert(*scheme, column);
	}
}

QList<QString> Scheme::schemes()
{
	return m_schemelist;
}

QStringList* Scheme::icons(QString scheme)
{
	return m_iconlist[scheme];
}

QStringList* Scheme::columns(QString scheme)
{
	return m_columnlist[scheme];
}

