#ifndef NOVINYL_SCHEME_H
#define NOVINYL_SCHEME_H

#include <qdict.h>
#include <qlist.h>
#include <qstring.h>
#include <qstringlist.h>

class Scheme
{
	public:
		static Scheme* instance();
		void init();
		QList<QString> schemes();
		QStringList* icons(QString scheme);
		QStringList* columns(QString scheme);

	private:
		Scheme();
		~Scheme();
		QList<QString> m_schemelist;
		QDict<QStringList> m_iconlist;
		QDict<QStringList> m_columnlist;
		
};

#endif

