#include "toplevel.h"

#include "board.h"
#include "entry.h"
#include "newdb.h"
#include "scheme.h"

#include <kfiledialog.h>
#include <kpopupmenu.h>
#include <kmenubar.h>
#include <ksimpleconfig.h>
#include <kstddirs.h>
#include <klocale.h>

Toplevel::Toplevel()
: KMainWindow()
{
	KPopupMenu *menu_file;

	entry = NULL;
	newdb = NULL;
	Scheme::instance()->init();

	menu_file = new KPopupMenu(this);
	menu_file->insertItem(i18n("New"), menufilenew);
	menu_file->insertItem(i18n("Open"), menufileopen);
	menu_file->insertSeparator();
	menu_file->insertItem(i18n("Save"), menufilesave);
	menu_file->insertItem(i18n("Save as..."), menufilesaveas);
	menu_file->insertSeparator();
	menu_file->insertItem(i18n("Quit"), menufilequit);

	menu_entry = new KPopupMenu(this);
	menu_entry->insertItem(i18n("New"), menuentrynew);
	menu_entry->insertItem(i18n("Modify"), menuentrymodify);
	menu_entry->insertItem(i18n("Delete selected"), menuentrydelete);
	menu_entry->setEnabled(false);

	menuBar()->insertItem(i18n("File"), menu_file);
	menuBar()->insertItem(i18n("Entries"), menu_entry);
	menuBar()->insertItem(i18n("Help"), helpMenu());

	board = new Board(this);
	setCentralWidget(board);
	show();

	connect(menu_file, SIGNAL(activated(int)), SLOT(slotMenu(int)));
	connect(menu_entry, SIGNAL(activated(int)), SLOT(slotMenu(int)));

	resize(600, 620);
}

Toplevel::~Toplevel()
{
}

void Toplevel::slotMenu(int id)
{
	QString x;
	QStringList l;

	switch(id)
	{
		case menufilenew:
			if(!newdb)
			{
				newdb = new NewDB();
				connect(newdb, SIGNAL(signalNewDB(QString)), SLOT(slotNewDB(QString)));
			}
			newdb->show();
			break;
		case menufileopen:
			x = KFileDialog::getOpenFileName(QString::null,
				"*.novinyl|Novinyl native (*.novinyl)\n*.ksp|KSpread export (*.ksp)");
			if(!x.isEmpty())
			{
				menu_entry->setEnabled(true);
				board->load(x);
				m_type = board->type();
				if(entry)
				{
					delete entry;
					entry = NULL;
				}
			}
			break;
		case menufilesave:
			x = KFileDialog::getSaveFileName(QString::null, "*.novinyl|Novinyl native (*.novinyl)");
			if(!x.isEmpty()) board->save(x);
			break;
		case menufilesaveas:
			x = KFileDialog::getSaveFileName(QString::null,
				"*.novinyl|Novinyl native (*.novinyl)\n*.ksp|KSpread export (*.ksp)");
			if(!x.isEmpty()) board->save(x);
			break;
		case menufilequit:
			close();
			break;
		case menuentrynew:
			if(!entry)
			{
				entry = new Entry();
				entry->init2(m_type);
				connect(entry, SIGNAL(signalNewTrack(QStringList)), board, SLOT(slotNewTrack(QStringList)));
			}
			entry->show();
			break;
		case menuentrymodify:
			if(!entry)
			{
				entry = new Entry();
				entry->init2(m_type);
				connect(entry, SIGNAL(signalNewTrack(QStringList)), board, SLOT(slotNewTrack(QStringList)));
			}
			l = board->list();
			//entry->hide(); // make gcc happy :)
			if(l.count())
			{
				entry->fill(l);
				entry->show();
			}
			break;
		case menuentrydelete:
			board->deleteTracks();
			break;
	}
}

void Toplevel::slotNewDB(QString type)
{
	newdb->hide();
	board->init2(type);
	m_type = type;
	board->clear();
	menu_entry->setEnabled(true);
	if(entry)
	{
		delete entry;
		entry = NULL;
	}
}

