#ifndef ENTRY_H
#define ENTRY_H

#include <qdialog.h>
#include <qstringlist.h>
#include <qptrlist.h>

class QLineEdit;
class QVBoxLayout;
class QGridLayout;
class QPushButton;

class Entry : public QDialog
{
	Q_OBJECT
	public:
		Entry(QWidget *parent = NULL, const char *name = NULL);
		~Entry();
		void init(int type);
		void init2(QString type);
		void fill(QStringList list);

	public slots:
		void slotAccept();
		void slotClearAll();

	signals:
		void signalNewTrack(QStringList list);

	private:
		QVBoxLayout *vbox;
		QGridLayout *grid;
		QPtrList<QLineEdit> editlist;
		QPushButton *ok, *cancel, *clearall;
};

#endif

