#ifndef NOVINYL_SCHEME_H
#define NOVINYL_SCHEME_H

#include <qdict.h>
#include <qptrlist.h>
#include <qstring.h>
#include <qstringlist.h>

class Scheme
{
	public:
		static Scheme* instance();
		void init();
		QPtrList<QString> schemes();
		QStringList* icons(QString scheme);
		QStringList* columns(QString scheme);

	private:
		Scheme();
		~Scheme();
		QPtrList<QString> m_schemelist;
		QDict<QStringList> m_iconlist;
		QDict<QStringList> m_columnlist;
		
};

#endif

