#include "toplevel.h"

#include "board.h"
#include "entry.h"
#include "newdb.h"
#include "scheme.h"

#include <kfiledialog.h>
#include <kpopupmenu.h>
#include <kmenubar.h>
#include <ksimpleconfig.h>
#include <kstandarddirs.h>
#include <klocale.h>

Toplevel::Toplevel()
: KMainWindow()
{
	KPopupMenu *menu_file;

	Scheme::instance()->init();

	menu_file = new KPopupMenu(this);
	menu_file->insertItem(i18n("New"), menufilenew);
	menu_file->insertItem(i18n("Open"), menufileopen);
	menu_file->insertSeparator();
	menu_file->insertItem(i18n("Save"), menufilesave);
	menu_file->insertItem(i18n("Save as..."), menufilesaveas);
	menu_file->insertSeparator();
	menu_file->insertItem(i18n("Quit"), menufilequit);

	menu_entry = new KPopupMenu(this);
	menu_entry->insertItem(i18n("New"), menuentrynew);
	menu_entry->insertItem(i18n("Modify"), menuentrymodify);
	menu_entry->insertItem(i18n("Duplicate selected"), menuentryduplicate);
	menu_entry->insertItem(i18n("Delete selected"), menuentrydelete);
	menu_entry->insertSeparator();
	menu_entry->insertItem(i18n("Unselect all"), menuentryclear);
	menu_entry->setEnabled(false);

	menuBar()->insertItem(i18n("File"), menu_file, menu_file_id);
	menuBar()->insertItem(i18n("Entries"), menu_entry, menu_entry_id);
	menuBar()->insertItem(i18n("Help"), helpMenu());
	menuBar()->setItemEnabled(menu_entry_id, false);

	board = new Board(this);
	setCentralWidget(board);
	show();

	connect(menu_file, SIGNAL(activated(int)), SLOT(slotMenu(int)));
	connect(menu_entry, SIGNAL(activated(int)), SLOT(slotMenu(int)));

	resize(600, 620);
}

Toplevel::~Toplevel()
{
}

void Toplevel::menuNewDB()
{
	NewDB newdb;

	connect(&newdb, SIGNAL(signalNewDB(QString)), SLOT(slotNewDB(QString)));
	newdb.exec();
}

void Toplevel::menuEntryNew()
{
	Entry entry;

	connect(&entry, SIGNAL(signalNewTrack(QStringList)), board, SLOT(slotNewTrack(QStringList)));
	entry.init2(m_type);
	entry.exec();
}

void Toplevel::menuEntryEdit()
{
	Entry entry;
	QStringList l;

	connect(&entry, SIGNAL(signalNewTrack(QStringList)), board, SLOT(slotNewTrack(QStringList)));
	entry.init2(m_type);

	l = board->list(true);
	if(l.count())
	{
		entry.fill(l);
		entry.show();
	}
	entry.exec();
}

void Toplevel::slotMenu(int id)
{
	QString x;

	switch(id)
	{
		case menufilenew:
			menuNewDB();
			break;
		case menufileopen:
			x = KFileDialog::getOpenFileName(QString::null,
				i18n("*.novinyl|Novinyl native (*.novinyl)\n*.ksp|KSpread export (*.ksp)"));
			if(!x.isEmpty())
			{
				menu_entry->setEnabled(true);
				board->load(x);
				m_type = board->type();
			}
			break;
		case menufilesave:
			x = KFileDialog::getSaveFileName(QString::null, i18n("*.novinyl|Novinyl native (*.novinyl)"));
			if(!x.isEmpty()) board->save(x);
			break;
		case menufilesaveas:
			x = KFileDialog::getSaveFileName(QString::null,
				i18n("*.novinyl|Novinyl native (*.novinyl)\n*.ksp|KSpread export (*.ksp)"));
			if(!x.isEmpty()) board->save(x);
			break;
		case menufilequit:
			close();
			break;
		case menuentrynew:
			menuEntryNew();
			break;
		case menuentrymodify:
			menuEntryEdit();
			break;
		case menuentryduplicate:
			board->slotNewTrack(board->list(false));
			break;
		case menuentrydelete:
			board->deleteTracks();
			break;
		case menuentryclear:
			board->clearSelection();
			break;
	}
}

void Toplevel::slotNewDB(QString type)
{
	board->init2(type);
	m_type = type;
	board->clear();

	menu_entry->setEnabled(true);
	menuBar()->setItemEnabled(menu_entry_id, true);
}

